#!/bin/sh
. /etc/ltsp.conf
# LTSP lpr apckage for ltsp V3.x
# Created by Andreas Kainz (andreas@kainz.com)
# based on lpr 0.50 from red hat 6.2

# Variables needed.
CURRENTDIR=`pwd`
XINETD_DIR="$LTSP_DIR/i386/etc/xinetd.d"
LPD_BIN="$LTSP_DIR/i386/usr/sbin/lpd"
echo $AUTOFS_DIR
WHOAMI=`whoami`
# Show Intro.
echo "LTSP lpr,  by Andreas Kainz (andreas@kainz.com)"

# Checks what version of bash you are running.
echo "Bash Version=$BASH_VERSION"
if [ ${BASH_VERSION:0:1} -lt "2" ]; then
 echo "BASH running less then version 2.xx could cause unforseen problems."
fi

if [ "$WHOAMI" != "root" ]; then
 echo "You must be *ROOT* to install this."
 exit
fi

if [ -d $XINETD_DIR ]; then
 echo
else 
 echo "ltsp local application support is not installed. Please install it first."
 exit
fi

if [ -d $LPD_BIN ]; then
 echo "ltsp lpr package is already installed."
 exit
fi

echo "Installing Base package."

cp -fr $CURRENTDIR/i386/* $LTSP_DIR/i386

if grep -q "^lp:" $LTSP_DIR/i386/etc/group ; then
	echo "lp group already installed"
else
	# insert lp group in 2nd line (root is first)
	echo "Creating lp group"
	sed -e "2ilp:x:7:" < $LTSP_DIR/i386/etc/group > $LTSP_DIR/i386/etc/group.new &&  mv $LTSP_DIR/i386/etc/group.new $LTSP_DIR/i386/etc/group  || echo "failed"
fi

if [ -f $LTSP_DIR/i386/etc/printcap ] ; then
	echo "$LTSP_DIR/i386/etc/printcap exists - skipping"
	echo "you have to manually configure your printcap!"
else
	ln -s /tmp/printcap $LTSP_DIR/i386/etc/printcap 
fi

echo "Installation *Complete*"

